
; Event Indicator
; Daily, Weekly or Fortnight indication 
; uses 32.768kHz crystal for timer1 to update each second

;	ERRORLEVEL -302
;	ERRORLEVEL -306


	    list      p=12F617            ; list directive to define processor
     #include <p12F617.inc>        ; processor specific variable definitions


 __CONFIG   _CP_OFF & _BOR_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON &_INTRC_OSC_NOCLKOUT & _IOSCFS_4MHZ &_WRT_OFF

; Bank 0 RAM

SECONDS			equ	H'20'	; seconds counter
MINUTES			equ	H'21'	; minutes counter
HOURS				equ	H'22'	; hours counter
DAYS1				equ	H'23'	; days counter for LED1
HOURS_FL			equ	H'24'	; 18-hour flash period
ONE_SET			equ	H'25'	; flags; weekly/ fortnightly
STORE1				equ	H'26'	; delay counter
STORE2				equ	H'27'	; delay counter
STORE3				equ	H'28'	; extra delay counter	
DURATION1			equ	H'29'	; duration S1 is closed	in seconds
WEEK_FORTNIGHT	equ	H'2A'	; week or fortnight setting with bit 0 (clear=week, set=fortnight)
NO_PER_DAY		equ	H'2B'	; Number of alerts per day bits 0 and 1 (0=1, 1=2, 2=3, 3=4)
FLASH				equ	H'2C'	; flash flag
TEMP				equ	H'2D'	; temporary working register
MODE				equ	H'2E'	; weekly/fortnightly or daily

; All Banks RAM
W_TMP				equ	H'70'	; storage of w before interrupt
STATUS_TMP		equ	H'71'	; status storage before interrupt

;DATA (4 blocks)
DATA1ms			equ	H'78'	; data of first byte ms
DATA1ls				equ	H'79'	; data

DATA2ms			equ	H'7A'	; data 
DATA2ls				equ	H'7B'	; data

DATA3ms			equ	H'7C'	; data 
DATA3ls				equ	H'7D'	; data

DATA4ms			equ	H'7E'	; data 
DATA4ls				equ	H'7F'	; data

;	org	H'400'		; start address of where data memory is stored

	org	0
	goto	SETUP
	org	4	
	goto	INTERRUPT

; ******************************************************************
SETUP
; set inputs/outputs
	movlw	B'00000000'
	movwf	GPIO			; ports low
	movlw	B'00000111'		; comparators off
	movwf	CMCON0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000100'		; pullups on/off. GP2 initially with pullup. Pullup off if JP2 inserted
	movwf	WPU
	movlw	B'00111100'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	movlw	B'00000000'		; settings 
	movwf	OPTION_REG

; analog/ digital inputs
	movlw	B'00000000'		; all digital 
	movwf	ANSEL
; Timer 1
	bcf		STATUS,RP0	; bank 0
	movlw	B'00001110'		; external clock
	movwf	T1CON 			; Timer 1, asynchronous operation, external oscillator (32.768kHz)
; start delay
; delay 
	movlw	D'5'				; 1s
	movwf	STORE3
LOOP_DEL1
	movlw	D'255'			; 200ms
	call		DELAYX			
	decfsz	STORE3,f
	goto	LOOP_DEL1

; start timer1
	bsf		T1CON,0

; initial conditions
	movlw	H'80'			; set for 1s
	movwf	TMR1H 			;
	clrf		TMR1L			; timer 1 is the seconds counter
	clrf		SECONDS		; Initialize timer counters
	clrf		MINUTES		; count minutes
	clrf		HOURS			; count hours
	clrf		DAYS1			; day number for LED1
	clrf		HOURS_FL		; LED flashing period
	clrf		DURATION1		; reset switch1 closure period
	clrf		FLASH			; flash flag
	clrf		MODE			; week/fortnight (bit0=0) or daily (bit 0=1)

; get MODE by reading GP2

; read input
	btfss	GPIO,2			; if high then weekly/fortnight
	goto	MODE_DAY		; daily
;______________________________________________________________

MODE_WEEK_FORTNIGHT

; read setting in WEEK_FORTNIGHT	; week or fortnight setting with bit 0 (clear=week, set=fortnight)
	call		READ			; read data memory 
; place in WEEK_FORTNIGHT	; 
	movwf	WEEK_FORTNIGHT

; check if switch pressed
	btfsc	GPIO,3
	goto	SHOW_SETTING
	movlw	D'255'			; 200ms
	call		DELAYX	
	btfsc	GPIO,3
	goto	SHOW_SETTING

; switch closed
	incf		WEEK_FORTNIGHT,f	; alternate week/fortnight setting for bit 0
; note that bit 1 when set, the period driving the GP1 output is increased so a piezo buzzer will chirp (set and cleared on consecutive weekly/fortnightly settings) 
	movf	WEEK_FORTNIGHT,w
	movwf	DATA1ls				; load into RAM for writing to data memory (not concerned about remaining data)
	call		WRITE				; store data

SHOW_SETTING
	call		DRIVE_LED1		; flash LED
; delay
	movlw	D'5'				; 1s
	movwf	STORE3
LOOP_DEL2
	movlw	D'255'			; 200ms
	call		DELAYX			
	decfsz	STORE3,f
	goto	LOOP_DEL2

	btfsc	WEEK_FORTNIGHT,0	; when set flash twice for a fortnight
	call		DRIVE_LED1		; flash LED
	goto	SW_OFF
;__________________________________________________________________

MODE_DAY
	bsf		MODE,0			; day setting

; set GP2 without pullup to conserve current draw when input is tied low
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'		; GP2 pullup off
	movwf	WPU
	bcf		STATUS,RP0	; select memory bank 0

; read setting in NO_PER_DAY	; 
	call		READ			; read data memory 
; place in Number of alerts per day bits 0 and 1 (0=1, 1=2, 2=3, 3=4) 
	movwf	NO_PER_DAY
	movwf	TEMP

; check if switch pressed
	btfsc	GPIO,3
	goto	SHOW_SETTING_D
	movlw	D'255'			; 200ms
	call		DELAYX	
	btfsc	GPIO,3
	goto	SHOW_SETTING_D

; switch closed
	incf		NO_PER_DAY,f	; Number of alerts per day bits 0 and 1 (0=1, 1=2, 2=3, 3=4)
	movf	NO_PER_DAY,w
	movwf	TEMP
	movwf	DATA1ls				; load into RAM for writing to data memory (only interested in data1ls)
	call		WRITE				; store data

SHOW_SETTING_D
	movlw	B'00000011'
	andwf	TEMP,f				; only have bits 0 and 1
	incf		TEMP,f
REPEAT_D
	call		DRIVE_LED1		; flash LED
; delay
	movlw	D'5'					; 1s
	movwf	STORE3
LOOP_DEL2_D
	movlw	D'255'				; 200ms
	call		DELAYX			
	decfsz	STORE3,f
	goto	LOOP_DEL2_D
; flash LED by number of alerts per day
	decfsz	TEMP,f
	goto	REPEAT_D			; flash again

;_________________________________________________________________

; wait for switch off
SW_OFF;?
	btfss	GPIO,3
	goto	SW_OFF		; is switch off ?	
	call		DELAY1			; 100ms
	btfss	GPIO,3
	goto	SW_OFF		; is switch off ?	

	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,TMR1IE		; Enable Timer1 interrupt
	movlw	B'00001000'
	movwf	IOC				; GP3 interrupt on change (IOC) for S1
	bcf		STATUS,RP0	; select memory bank 0
	
	movf	GPIO,w			; read inputs to allow flag clearing
	bcf		INTCON,GPIF	; GP3 interrupt flag off
	bcf 		PIR1,TMR1IF		; clear timer interrupt flag
	bsf		INTCON,PEIE	; enable peripheral interrupts
	bsf		INTCON,GPIE	; GPIO3 interrupt (IOC)
	bsf		INTCON,GIE		; enable interrupts

CYCLE
	SLEEP					; stop program to conserve power
	nop						; wakes here from sleep every second

; S1 short press clears flashing LED. Long press resets timer to zero and starts LED flashing as in the week/fortnight indication.
; Can be cleared with short press of S1

; check if S1 already pressed (indicated with DURATION1 >0)

	movf	DURATION1,w
	btfss	STATUS,Z	; if zero, check if S1 pressed
	goto	CLOSED	; see if still closed	
; check if switch pressed
	btfsc	GPIO,3
	goto	OPEN
	goto	BY_RESET	; switch detected in interrupt

CLOSED; check if switch is still closed
	btfss	GPIO,3
	goto	CK_DUR
; delay for opening
	call		DELAY1
OPEN
; when switch is open clear DURATION1
	clrf		DURATION1
; re-allow switch interrupt
	movf	GPIO,w			; read inputs	
	bcf		INTCON,GPIF	; flag cleared
	bsf		INTCON,GPIE	; interrupt start 
	goto	BY_RESET
CK_DUR
; check DURATION1 (period that S1 is pressed)
;
	movf	DURATION1,w
	sublw	D'5'			; if >5s then reset days, hours minutes to restart time period from zero
	btfsc	STATUS,C
	goto	BY_RESET

SET_CLEAR
; set HOURS_FL counter for LED flashing
	bcf		INTCON,GIE	; disable interrupt
; check MODE
	btfsc	MODE,0
	goto	MODE_FL_DAY

; weekly/fortnight
	movlw	D'18'		; 18-hours
	movwf	HOURS_FL
	goto	SET_S

;daily
MODE_FL_DAY
; set HOURS_FL counter for LED flashing alert period
; value in HOURS_FL depends on setting
; bits 1,0
;	ALERTS  Spread		Alert period
; 00; 1       	24hr			18 hours
; 01; 2    		12hr			8 hours
; 10; 3		8hr			6 hours
; 11; 4		6hr			4 hours
	movf	NO_PER_DAY,w	; number of alerts per day
	andlw	B'0000011'		; keep bits 0 and 1
	movwf	TEMP
;00
	movf	TEMP,w
	btfsc	STATUS,Z
	movlw	D'18'			; 18 hours for 00 (once per day indication) 
;01
	decf	TEMP,f
	btfsc	STATUS,Z		
	movlw	D'8'
;10
	decf	TEMP,f
	btfsc	STATUS,Z		
	movlw	D'6'
;11
	decf	TEMP,f
	btfsc	STATUS,Z		
	movlw	D'4'
 
	movwf	HOURS_FL

SET_S
	movlw	H'80'		; set for 1s
	movwf	TMR1H 		;
	clrf		TMR1L
	clrf		SECONDS		; initialize timer counters
	clrf		MINUTES
	clrf		HOURS
	clrf		DAYS1

; re-allow switch interrupt
	movf	GPIO,w			; read inputs	
	bcf		INTCON,GPIF	; flag cleared
	bsf		INTCON,GPIE	; interrupt start 

;________________________________________________________
; * test ;  
;	btfsc	MODE,0
;	goto	DAY_TEST

;weekly/fortnight test
;to have progression to next week in 1 minute (see also in interrupt for changes required)
; plus reduce alert period and rapid week/fortnight test

;  7minutes cycle for weekly and 14minutes cycle for fortnightly

; 1minute is 1 day
;	movlw	D'23'
;	movwf	HOURS
;	movlw	D'59'
;	movwf	MINUTES

; alert period (18 hours down to 1 minute)
;	movlw	D'1'		; 1 minute
;	movwf	HOURS_FL
;	goto	ENABLE_I

 DAY_TEST
; * test to have progression to next day in 24 minutes
; 1minute test = 1 hour

;	movlw	D'59'
;	movwf	MINUTES

; * end test	
;________________________________________________________

ENABLE_I
	bsf		INTCON,GIE	; enable interrupt
	movf	FLASH,w	; if not zero bypass
	btfss	STATUS,Z
	goto	CYCLE
	bsf		FLASH,1	; set flash flag so LED flash sequence starts
	goto	CYCLE
BY_RESET
; check if LED should flash
	movf	HOURS_FL,w
	btfsc	STATUS,Z
	goto	CYCLE
; flash LED
	movf	FLASH,w	; if not zero bypass
	btfss	STATUS,Z
	goto	CYCLE
	bsf		FLASH,1	; set flash flag so LED flash sequence starts
	goto	CYCLE
	
; ****************************************************
; subroutines

DELAY1
	movlw	D'125'	; 100ms
DELAY2
DELAYX
	movwf	STORE1
LOOP2
	movlw	D'255'
	movwf	STORE2
LOOP1
	decfsz	STORE2,f
	goto	LOOP1
	decfsz	STORE1,f
	goto	LOOP2
	return

DELAY3; Charge delay
	movwf	STORE1
LOOP4
	movlw	D'15'					; about 12ms
	movwf	STORE2
LOOP3
	decfsz	STORE2,f
	goto	LOOP3
	decfsz	STORE1,f
	goto	LOOP4
	return

DELAY4; Discharge delay about 12ms
	movwf	STORE1
LOOP6
	movlw	D'15'					; 15ms 
	movwf	STORE2
LOOP5
	decfsz	STORE2,f
	goto	LOOP5
	decfsz	STORE1,f
	goto	LOOP6
	return

DRIVE_LED1
; charge
; set  GP1 high and GP0 low to charge 100uF capacitor
	movlw	B'00000010'
	movwf	GPIO
; delay to charge. Varies for if buzzer required or not
   	movlw	D'255'
	call 		DELAY3
; flash LED1
; GP1 low, GP0 high
	movlw	B'00000001'
	movwf	GPIO
 ; delay to flash 
  	movlw	D'255'
	call 		DELAY4 
; resting state, GP0 and GP1 low
	movlw	B'00000000'
	movwf	GPIO		;  prevent flow through LED
	return

; read data memory
READ
	bsf		STATUS,RP0	; select memory bank 1 
	movlw 	H'04'
	movwf 	PMADRH		; ms Byte of Program Address to read
	movlw	H'00'
	movwf 	PMADRL 		; ls Byte of Program Address to read

	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
;	movf	PMDATH,w 		; ms Byte of Program data (not required)
; only require ls byte for this particular code
	movf	PMDATL,w 		; ls Byte of Program data
	bcf		STATUS,RP0	; bank 0
	return

; write to data memory
WRITE
; This write routine assumes the following:
; A valid starting address (the least significant bits = '00')
; is loaded in ADDRH:ADDRL
; ADDRH, ADDRL and DATADDR are all located in data memory
;
	bsf		STATUS,RP0	; select memory bank 1
	movlw 	H'04'
	movwf 	PMADRH		; MS Byte of Program Address to write
	movlw	H'00'
	movwf 	PMADRL 		; LS Byte of Program Address to write

	movlw	H'78'			; Load initial data address
	movwf	FSR 
LOOP_WRITE 
	movf	 INDF,w 			; Load first data byte into upper byte
	movwf	 PMDATH		;
	incf		 FSR,f 			; Next byte
	movf	 INDF,w 			; Load second data byte into lower byte
	movwf	 PMDATL 		; 		
	incf		 FSR,f 			;
	bsf		 PMCON1,WREN ; Enable writes

;CHECK_GIE; comment out if not using interrupt whilst writing
;	bcf		 INTCON,GIE 	; Disable interrupts 
;	btfsc	 INTCON,GIE 	; check if disabled
;	goto	CHECK_GIE
;
; Required Sequence
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2		; Write 55h
	movlw	H'AA'		 	;
	movwf	PMCON2 		; Write AAh
	bsf		PMCON1,WR 	; Set WR bit to begin write
	nop					 	; NOPs required for time to transfer data to the buffer registers
	nop						; 
;
	bcf		 PMCON1,WREN ; Disable writes
;	bsf		 INTCON,GIE 	; Re-enable interrupts (comment out if not using interrupts)

	movf	PMADRL,w
	incf		PMADRL,f		; Increment address
; select 4,8,12 or16 	
	; 0F = 16 words
	; 0B = 12 words
	; 07 =  8 words
	; 03 =  4 words
	andlw	H'03'			; Indicates when the set number of words have been programmed
	sublw	H'03'

	btfss	STATUS,Z 		; Exit on a match,
	goto	LOOP_WRITE	; Continue until ended
	bcf		STATUS,RP0	; bank 0
	return

; *************************************************
INTERRUPT
; start interrupt by saving w and status registers 
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1

; check if switch closed
	btfss	INTCON,GPIF	; if set then set duration and clear alarm period
	goto	SECOND_INT	; seconds interrupt
; switch pressed 
; read GP3
	movf	GPIO,w
	bcf		INTCON,GPIF	; flag clear	 

	call		DELAY1
	btfsc	GPIO,3			; if switch closed
	goto	SECOND_INT	; seconds interrupt
	bcf		INTCON,GPIE	; flag and interrupt cleared so stop switch interrupt
	nop
; read GP3
	movf	GPIO,w
	bcf		INTCON,GPIF
	movlw	D'01'			; switch pressed counter, flag that switch is pressed
	movwf	DURATION1
; clear hours counter
	clrf		HOURS_FL
	clrf		FLASH			; stop flash flag

SECOND_INT; seconds interrupt
	btfss	PIR1,TMR1IF
	goto	END_INTERRUPT

;-------------------------------------------------------------------
; check if LED is requested to flash
	movf	FLASH,w
	btfsc	STATUS,Z
	goto	FLASH_OFF	; when clear, clear GP0 and GP1 
; when FLASH,1 is set then charge LED (GP1is  high and so piezo can also be driven) 
	btfsc	FLASH,1	; if set, charge capacitor
	goto	CHARGE
; when FLASH,0 is set than drive LED 
	btfsc	FLASH,0	; if set, drive LED
	goto	DRIVE_LED
	goto	FLASH_OFF
CHARGE
; set  GP1 high and GP0 low to charge 100uF capacitor
	movlw	B'00000010'
	movwf	GPIO
	bcf		FLASH,1
	bsf		FLASH,0		; allows LED to be driven on next interrupt
	goto	UP_CK			; update clock
DRIVE_LED
; flash LED1
; GP1 low, GP0 high
	movlw	B'00000001'
	movwf	GPIO
 ; delay to flash 
  	movlw	D'255'
	call 		DELAY4 
	clrf		FLASH			; end of flash
FLASH_OFF
; resting state, GP0 and GP1 low
	movlw	B'00000000'
	movwf	GPIO		;  prevent flow through LED
;---------------------------------------------------------------------------------------

UP_CK ; update clock and week days 

; *******************************************
; start test **
; required here for rapid testing (see in switch reset for extra line also required)
; rapid test by presetting timer so 1m = 1day
;	movlw	D'23'
;	btfss	MODE,0		; set hours to 23 in week/fortnight mode
;	movwf	HOURS
;	movlw	D'59'
;	movwf	MINUTES	
; end test **

; *******************************************

	bsf		TMR1H,7 	; set for 1 second
	incf		SECONDS,f	; seconds

; duration. (switch pressed duration)
; increment 'duration1' if not 0
	movf	DURATION1,w
	btfss	STATUS,Z	; check for 0
	incf		DURATION1,f

; check for 60s
	movf	SECONDS,w
	sublw	D'60'
	btfss	STATUS,Z 		; 60 seconds
	goto	END_INTERRUPT	; not 60s
	clrf		SECONDS		; clear seconds

INC_MIN
	incf		MINUTES,f 		; next minutes

; check for 60 minutes
	movf	MINUTES,w
	sublw	D'60'
	btfss	STATUS,Z 		; 60 minutes
	goto	END_INTERRUPT	; not 60mins
	clrf		MINUTES		; clear minutes

	incf		HOURS,f		; next hours

; decrease HOURS_FL counter for flash duration
	movf	HOURS_FL,w
	btfss	STATUS,Z		; do not decrement if already zero
	decf	HOURS_FL,f

;___________________________________________________
;Check Mode
	btfsc	MODE,0
	goto	DAY_ALERT

; check for 24 hours
	movf	HOURS,w
	sublw	D'24'
	btfss	STATUS,Z 			; 24 hours 
	goto	END_INTERRUPT	; not 24 hours
	clrf		HOURS				; clear hours

; weekly/fortnight mode
; days1
DAYS_1
	incf		DAYS1,f		; next day
; weekly or fortnightly?
	btfsc	WEEK_FORTNIGHT,0
	goto	FOURTEEN
SEVEN
	movf	DAYS1,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	CLR_DY1
	goto	END_INTERRUPT

; 14th day
FOURTEEN
	movf	DAYS1,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 7 days 
	goto	CLR_DY1
	btfsc	STATUS,C	; if negative (ie >14) then clear
	goto	END_INTERRUPT

CLR_DY1
	clrf		DAYS1

; set HOURS_FL counter for LED flashing
	movlw	D'18'			; 18-hours
;____________________________________________________________
; **test
;	movlw	D'1'				; 1 minute test when minutes and hours set for rapid
;________________________________________________________________

	movwf	HOURS_FL
	goto	END_INTERRUPT

DAY_ALERT

; check for 24 hours
	movf	HOURS,w
	sublw	D'24'
	btfsc	STATUS,Z 			; 24 hours 
	clrf		HOURS				; clear hours if 24

; check if alert required
; bits 1,0 in HOURS_FL
;bits ALERTS  Spread		Alert period
; 00;  1       	24hr			18 hours
; 01;  2    		12hr			8 hours
; 10;  3		8hr			6 hours
; 11;  4		6hr			4 hours
	movf	NO_PER_DAY,w	; number per day
	andlw	B'0000011'		; keep bits 0 and 1
	movwf	TEMP

ONE_PER_DAY
;00
; if bits 00, check at 0 hour spot and set flash if at 24h
; check if hours are 0 (same as after 24 hours)
	movf	HOURS,w
	btfss	STATUS,Z		; if zero
	goto	TWO_PER_DAY
ONCE
	movf	TEMP,w
	btfsc	STATUS,Z		; if bits 1,0 in NO_PER_DAY are both 0
	goto	SET_FLASH

TWO_PER_DAY
;01
; if bits 01, check at 12 and 0 hour spot and set flash if at 0h or 12h
; check if hours are 0 (same as after 24 hours) or 12
	movf	HOURS,w
	btfsc	STATUS,Z			; 0
	goto	TWICE
	movf	HOURS,w
	xorlw	D'12'				; 12
	btfss	STATUS,Z
	goto	THREE_PER_DAY
TWICE
	movf	TEMP,w			; NO_PER_DAY with just bits 0 and 1 visible
	xorlw	B'00000001'
	btfsc	STATUS,Z
	goto	SET_FLASH		; set the flash period

THREE_PER_DAY
;10
; if bits 10, check at 0,  8 and 16 hour spots and set flash if so
; check if hours are 0 (same as 24 hours) or 8 or 12
	movf	HOURS,w
	btfsc	STATUS,Z			; 0
	goto	THREES
	movf	HOURS,w
	xorlw	D'8'					; 8
	btfsc	STATUS,Z
	goto	THREES
	movf	HOURS,w
	xorlw	D'16'				; 16
	btfss	STATUS,Z
	goto	FOUR_PER_DAY
THREES
	movf	TEMP,w			; NO_PER_DAY with just bits 0 and 1 visible
	xorlw	B'00000010'
	btfsc	STATUS,Z
	goto	SET_FLASH		; set the flash period

FOUR_PER_DAY
;11
; if bits 11, check at 0,  6,  12 and 18 hour spots and set flash if so
; check if hours are 0 (same as 24 hours) or 6 or 12 or 18
	movf	HOURS,w
	btfsc	STATUS,Z			; 0
	goto	FOURS
	movf	HOURS,w
	xorlw	D'6'					; 6
	btfsc	STATUS,Z
	goto	FOURS
	movf	HOURS,w
	xorlw	D'12'				;12
	btfsc	STATUS,Z
	goto	FOURS
	movf	HOURS,w
	xorlw	D'18'				; 18
	btfss	STATUS,Z
	goto	END_INTERRUPT
FOURS
	movf	TEMP,w			; NO_PER_DAY with just bits 0 and 1 visible
	xorlw	B'00000011'
	btfsc	STATUS,Z
	goto	SET_FLASH		; set the flash period

	goto	END_INTERRUPT

SET_FLASH; set flash period

ALERT_PERIOD
	
; set HOURS_FL counter for LED flashing alert period
; value in HOURS_FL depends on setting
; bits 1,0
;	ALERTS  Spread		Alert period
; 00; 1       	24hr			18 hours
; 01; 2    		12hr			8 hours
; 10; 3		8hr			6 hours
; 11; 4		6hr			4 hours
	movf	NO_PER_DAY,w
	andlw	B'0000011'		; keep bits 0 and 1
	movwf	TEMP
;B'00'
	movf	TEMP,w
	btfsc	STATUS,Z
	movlw	D'18'			; 18 hours for 00 (once per day indication) 
;B'01'
	decf	TEMP,f
	btfsc	STATUS,Z		
	movlw	D'8'				; 8 hours
;B'10'
	decf	TEMP,f
	btfsc	STATUS,Z		
	movlw	D'6'				; six hours
;B'11'
	decf	TEMP,f
	btfsc	STATUS,Z		
	movlw	D'4'				; four hours
 
	movwf	HOURS_FL		; place in flash counter

END_INTERRUPT
	bcf 		PIR1,TMR1IF 	; clear timer interrupt flag
	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS			; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   	W_TMP,w		; swap bits and into w register
	retfie					; return from interrupt

	end


